function [Pos,NewMin,NewMax]= MaxEnergy(handles)
% Restricts the position of the Slider to the Energy range in case several energy slices are added up (see DispRange). 

%% Get Handles
MaxMin    = get(handles.Slider, 'UserData');
EnergyRes = get(handles.Slider, 'SliderStep');
NewMax    = str2double(get(handles.MaxEnergy, 'String'));
NewMin    = str2double(get(handles.MinEnergy, 'String'));
OldEnergy = str2double(get(handles.DispEnergy,'String'));
DispRange = str2double(get(handles.DispRange,'String'));

%% Calculate
EnergyRes=EnergyRes(1);
DispRange = (DispRange-EnergyRes)/2;

TotalMax=MaxMin(1);
if NewMax + DispRange > TotalMax
    NewMax = TotalMax-DispRange;
elseif NewMax < NewMin
    NewMax = NewMin;
end
Pos = OldEnergy;
if Pos<NewMin
    Pos=NewMin;
elseif Pos>NewMax
    Pos=NewMax;
end
clearvars -except Pos NewMin NewMax
end